/*
 * Decompiled with CFR 0.152.
 */
package LegendaryCardMaker.CustomCardMaker.structure;

import LegendaryCardMaker.CustomCardMaker.CustomCardMaker;
import LegendaryCardMaker.CustomCardMaker.GaussianFilter;
import LegendaryCardMaker.CustomCardMaker.structure.CustomTemplate;
import LegendaryCardMaker.Icon;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;

public class CustomElement
implements Cloneable {
    public String name;
    public CustomTemplate template;
    public List<CustomElement> childElements = new ArrayList<CustomElement>();
    public boolean visible = true;

    public void drawElement(Graphics2D g) {
    }

    public BufferedImage getIcon(Icon icon, int maxWidth, int maxHeight) {
        ImageIcon ii = new ImageIcon(icon.getImagePath());
        double r = 1.0;
        double rX = (double)maxWidth / (double)ii.getIconWidth();
        double rY = (double)maxHeight / (double)ii.getIconHeight();
        r = rY < rX ? rY : rX;
        return this.resizeImage(ii, r);
    }

    public BufferedImage getIconMaxHeight(Icon icon, int maxHeight) {
        ImageIcon ii = new ImageIcon(icon.getImagePath());
        double r = (double)maxHeight / (double)ii.getIconHeight();
        return this.resizeImage(ii, r);
    }

    public int getPercentageValue(int value, int max) {
        return (int)Math.round((double)value / (double)max * 100.0);
    }

    public int getPercentage(int size, double scale) {
        return (int)((double)size * scale);
    }

    public BufferedImage resizeImage(ImageIcon imageIcon, double scale) {
        int w = (int)((double)imageIcon.getIconWidth() * scale);
        int h = (int)((double)imageIcon.getIconHeight() * scale);
        int type = 2;
        if (w <= 0 || h <= 0) {
            return null;
        }
        BufferedImage image = new BufferedImage(w, h, type);
        Graphics2D g = this.getGraphics(image);
        g.drawImage(imageIcon.getImage(), 0, 0, w, h, 0, 0, imageIcon.getIconWidth(), imageIcon.getIconHeight(), null);
        g.dispose();
        return image;
    }

    public BufferedImage resizeImage(ImageIcon imageIcon, int width, int height) {
        int type = 2;
        BufferedImage image = new BufferedImage(width, height, type);
        Graphics2D g = this.getGraphics(image);
        g.drawImage(imageIcon.getImage(), 0, 0, width, height, 0, 0, imageIcon.getIconWidth(), imageIcon.getIconHeight(), null);
        g.dispose();
        return image;
    }

    public static ConvolveOp getGaussianBlurFilter(int radius, boolean horizontal) {
        if (radius < 1) {
            throw new IllegalArgumentException("Radius must be >= 1");
        }
        int size = radius * 2 + 1;
        float[] data = new float[size];
        float sigma = (float)radius / 3.0f;
        float twoSigmaSquare = 2.0f * sigma * sigma;
        float sigmaRoot = (float)Math.sqrt((double)twoSigmaSquare * Math.PI);
        float total = 0.0f;
        int i = -radius;
        while (i <= radius) {
            float distance = i * i;
            int index = i + radius;
            data[index] = (float)Math.exp(-distance / twoSigmaSquare) / sigmaRoot;
            total += data[index];
            ++i;
        }
        i = 0;
        while (i < data.length) {
            int n = i++;
            data[n] = data[n] / total;
        }
        Kernel kernel = null;
        kernel = horizontal ? new Kernel(size, 1, data) : new Kernel(1, size, data);
        return new ConvolveOp(kernel, 1, null);
    }

    public BufferedImage blackoutImage(BufferedImage image, Color blackoutColor) {
        int width = image.getWidth();
        int height = image.getHeight();
        int xx = 0;
        while (xx < width) {
            int yy = 0;
            while (yy < height) {
                Color originalColor = new Color(image.getRGB(xx, yy), true);
                if (originalColor.getAlpha() > 0) {
                    image.setRGB(xx, yy, blackoutColor.getRGB());
                }
                ++yy;
            }
            ++xx;
        }
        return image;
    }

    public void drawUnderlay(BufferedImage bi, Graphics g, int type, int x, int y, int blurRadius, boolean doubleBlur, int expandBlackout, Color underlayColour) {
        BufferedImage blackout = new BufferedImage(CustomCardMaker.cardWidth, CustomCardMaker.cardHeight, type);
        this.getGraphics(blackout).drawImage((Image)bi, x, y, null);
        blackout = this.blackoutImage(blackout, underlayColour);
        if (expandBlackout > 0) {
            blackout = this.expandBlackout(blackout, expandBlackout, underlayColour);
        }
        if (blurRadius > 0) {
            GaussianFilter op = new GaussianFilter(blurRadius);
            BufferedImage bi2 = op.filter(blackout, null);
            g.drawImage(bi2, 0, 0, null);
            if (doubleBlur) {
                BufferedImage bi3 = op.filter(bi2, null);
                g.drawImage(bi3, 0, 0, null);
            }
        } else {
            g.drawImage(blackout, 0, 0, null);
        }
    }

    public BufferedImage blurImage(BufferedImage bi, Graphics g, int blurRadius) {
        if (blurRadius > 0) {
            GaussianFilter op = new GaussianFilter(blurRadius);
            BufferedImage bi2 = op.filter(bi, null);
            return bi2;
        }
        return bi;
    }

    public BufferedImage expandBlackout(BufferedImage image, int expandBlackout, Color blackoutColor) {
        BufferedImage expand = new BufferedImage(CustomCardMaker.cardWidth, CustomCardMaker.cardHeight, 2);
        int width = image.getWidth();
        int height = image.getHeight();
        int xx = 0;
        while (xx < width) {
            int yy = 0;
            while (yy < height) {
                Color originalColor = new Color(image.getRGB(xx, yy), true);
                if (originalColor.getAlpha() > 0) {
                    int i = expandBlackout;
                    while (i > 0) {
                        try {
                            expand.setRGB(xx, yy - i, blackoutColor.getRGB());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        try {
                            expand.setRGB(xx, yy + i, blackoutColor.getRGB());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        try {
                            expand.setRGB(xx - i, yy, blackoutColor.getRGB());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        try {
                            expand.setRGB(xx + i, yy, blackoutColor.getRGB());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (i == 1) {
                            try {
                                expand.setRGB(xx - i, yy - i, blackoutColor.getRGB());
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            try {
                                expand.setRGB(xx - i, yy + i, blackoutColor.getRGB());
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            try {
                                expand.setRGB(xx + i, yy - i, blackoutColor.getRGB());
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            try {
                                expand.setRGB(xx + i, yy + i, blackoutColor.getRGB());
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        --i;
                    }
                }
                ++yy;
            }
            ++xx;
        }
        return expand;
    }

    public Icon isIcon(String str) {
        block3: {
            try {
                if (str == null || str.startsWith("<") || str.endsWith(">")) break block3;
                return null;
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }
        Icon i = Icon.valueOf(str.replace("<", "").replace(">", ""));
        return i;
    }

    public CustomElement getCopy() {
        try {
            return (CustomElement)this.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public String generateOutputString() {
        return this.generateOutputString(false);
    }

    public String generateOutputString(boolean fullExport) {
        return "";
    }

    public Graphics2D getGraphics(BufferedImage bi) {
        Graphics2D g2 = (Graphics2D)bi.getGraphics();
        g2.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        return g2;
    }

    public Graphics2D setGraphicsHints(Graphics2D g2) {
        g2.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        return g2;
    }
}

